/*-----------------------------------------------------------------------*
 * filename - winbinit.c 
 * 
 * Init/cleanup of globals for EPOC winsb/wincb
 *
 * function(s)
 *      _init_exit_proc - return address of next _INIT_ proc
 *-----------------------------------------------------------------------*/

/*
 *      C/C++ Run Time Library - Version 11.0
 *
 *      Copyright (c) 2002, 2004 by Borland Software Corporation
 *      All Rights Reserved.
 *
 */

/* $Revision: 9.7 $  */

#include <_startup.h>

/* The RTL headers have this as an extern. However, __setargv__ normally lives
   in source\process, which is not needed for the Symbian RTL so we define this
   here to prevent unresolved externals.
 */
int _setargv__ = 0;

MULTI_INIT _dll_table;       /* DLL's init table */
MULTI_INIT _exe_table;       /* EXE's init table */

/*---------------------------------------------------------------------*

Name            _init_exit_proc - return address of next _INIT_ function

Usage           VOIDFUNC _init_exit_proc(MULTI_INIT *init_table, int is_exit);

Description     This function returns the address of the next function
                to call in the _INIT_ segments listed in the MULTI_INIT
                table pointed to by init_table.

                The is_exit flag is zero if this a startup table, and 1
                if this is an exit table. this affects whether the _INIT_
                functions are to be called in high-to-low or
                low-to-high priority order.

Return value    The address of the next function to call, or NULL if
                all INIT functions have been called.

*---------------------------------------------------------------------*/
void _init_exit_proc(MULTI_INIT *init_table, int is_exit)
{
    /* This function iterates through all the #pragma startup/exit entries
       that have been registered in the system and calls them in the correct
       priority order.  The compiler will generate an instance of an INIT
       structure for each #pragma startup/exit statement in each module that
       it compiles.  All the entries marked as startup are generated into
       the _INIT_ segment and all the entries marked as exit are generated
       into the _EXIT_ segment.  The startup code then calculates the
       beginning and ending of each of these segments and eventually passes
       them into here as elements of the MULTI_INIT and MODULE_DATA
       structures.
    */

    INIT *table_start, *table_end, *ip;
    MODULE_DATA *modtable;
    int prior, i, start, end, incr;

    if (is_exit) /* EXIT table: process priorities from 255 -> 0 */
    {
        start = 0xff;   /* Start at 255     */
        end   = -1;     /* end prior to -1  */
        incr  = -1;     /* decrement        */
    }
    else         /* INIT table: process priorities from 0 -> 255 */
    {
        start = 0;      /* start at 0       */
        end   = 0x100;  /* end prior to 256 */
        incr  = 1;      /* increment        */
    }

    for (prior = start; prior != end; prior += incr)
    {
        for (i = 0; i < init_table->ntables; i++) /* for each _INIT_ table */
        {
            modtable = init_table->table[i];
            table_start = is_exit ? modtable->exit_start : modtable->init_start;
            table_end   = is_exit ? modtable->exit_end   : modtable->init_end;

            /* Scan through each table, looking, in priority order, for the
               next entry that needs to be called.  Priority 0 is highest.
               If this is an INIT table, start with the highest priority
               entries. If this is an EXIT table, start with the lowest
               priority entries.  In the case of duplicate priorities, we
               want the first one to be used for INIT entries and the last
               one to be used for EXIT entries.  We do this by making the
               loop take the first one it finds, but we run the EXIT loop
               from back to front so that the first one it finds is really
               the last one in the table.
            */

            if (is_exit == 0)  /* INIT: run the table front to back */
            {
                for (ip = table_start; ip < table_end; ip++)
                {
                    if ((unsigned char)prior == ip->priority)
                    {
                        ip->func();   /* call the INIT function */
                    }
                }
            }
            else /* EXIT: run the table back to front */
            {
                for (ip = table_end-1; ip >= table_start; ip--)
                {
                    if ((unsigned char)prior == ip->priority)
                    {
                        ip->func();   /* call the EXIT function */
                    }
                }
            }
        }
    }
}

extern MODULE_DATA _module_data;

int __dll_count=0;

void _exe_init_proc() {
  /* Make up a MULTI_INIT structure for this EXE.
   */
  _exe_table.ntables = 1;
  _exe_table.table[0] = &_module_data;
  _init_exit_proc(&_exe_table,0);
}
void _exe_exit_proc() {
  /* Make up a MULTI_INIT structure for this EXE.
   */
  _exe_table.ntables = 1;
  _exe_table.table[0] = &_module_data;
  _init_exit_proc(&_exe_table,1);
}

void _dll_init_proc() {

  /* Make up a MULTI_INIT structure for this DLL.
   */
  _dll_table.ntables = 1;
  _dll_table.table[0] = &_module_data;
  _init_exit_proc(&_dll_table,0);
}
void _dll_exit_proc() {

  /* Make up a MULTI_INIT structure for this DLL.
   */
  _dll_table.ntables = 1;
  _dll_table.table[0] = &_module_data;
  _init_exit_proc(&_dll_table,1);
}
